/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.CtrHttpApi;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.swing.JOptionPane;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class FXMLSesionController
implements Initializable {
    @FXML
    private AnchorPane anpPrincipal;
    @FXML
    private Button btnFinalizar;
    private CtrHttpApi api;
    private JSONParser parser;
    private long idUso;

    public void initialize(URL url, ResourceBundle rb) {
        this.api = new CtrHttpApi();
        this.parser = new JSONParser();
        this.btnFinalizar.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXMLSesionController.this.cerrarSesion(event);
                event.consume();
            }
        });
    }

    private void cerrarSesion(ActionEvent event) {
        String json = "{\"idUso\": \"" + this.idUso + "\"}";
        try {
            JSONObject consulta = (JSONObject)this.parser.parse(this.api.consulta("finUso", json));
            String status = consulta.get((Object)"status").toString();
            String respuesta = consulta.get((Object)"respuesta").toString();
            if (status.equals("200") && respuesta.equals("true")) {
                JOptionPane.showMessageDialog(null, "Gracias por la visita");
                this.abrirLogin(event);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void abrirLogin(ActionEvent event) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/xml/FXMLLogin.fxml"));
            Parent root = (Parent)loader.load();
            Scene scene = new Scene(root);
            Stage stage = new Stage();
            Screen screen = Screen.getPrimary();
            Rectangle2D bounds = screen.getVisualBounds();
            stage.setX(bounds.getMinX());
            stage.setY(bounds.getMinY());
            stage.setWidth(bounds.getWidth());
            stage.setHeight(bounds.getHeight());
            stage.setMaximized(true);
            stage.setFullScreenExitHint("");
            stage.setAlwaysOnTop(true);
            stage.setResizable(false);
            stage.initStyle(StageStyle.UNDECORATED);
            stage.setOnCloseRequest(e -> e.consume());
            stage.setScene(scene);
            stage.show();
            Node source = (Node)event.getSource();
            Stage stagePrincipal = (Stage)source.getScene().getWindow();
            stagePrincipal.close();
        }
        catch (IOException ex) {
            Logger.getLogger(FXMLSesionController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setIdUso(long idUso) {
        this.idUso = idUso;
    }
}

