/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.CtrEncriptar;
import controller.CtrHttpApi;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javax.swing.JOptionPane;
import model.mdl_Telecentro;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class FXMLConfiguracionController
implements Initializable {
    @FXML
    private ComboBox cboTelecentro;
    @FXML
    private TextField txtNombrePuesto;
    @FXML
    private PasswordField txtContrasenaMaster;
    @FXML
    private PasswordField txtContrasenaMasterConfirmar;
    @FXML
    private Button btnGuardarTelecentro;
    @FXML
    private VBox vboxMensajeTelecentro;
    @FXML
    private Label lblMensajeTelecentro;
    private CtrHttpApi api;
    private JSONParser parser;
    private JSONArray arrayTelecentros;
    private ObservableList<mdl_Telecentro> listaTelecentros;

    public void initialize(URL url, ResourceBundle rb) {
        this.api = new CtrHttpApi();
        this.parser = new JSONParser();
        this.vboxMensajeTelecentro.setVisible(false);
        this.listaTelecentros = FXCollections.observableArrayList();
        this.listaTelecentros.add((Object)new mdl_Telecentro(0, "SELECCIONE EL TELECENTRO"));
        try {
            this.arrayTelecentros = (JSONArray)((JSONObject)this.parser.parse(this.api.consulta("telecentros", "{}"))).get((Object)"respuesta");
            for (Object obj : this.arrayTelecentros) {
                JSONObject tipo = (JSONObject)obj;
                this.listaTelecentros.add((Object)new mdl_Telecentro(Integer.parseInt(tipo.get((Object)"TEL_Telecentro").toString()), tipo.get((Object)"TEL_Nombre").toString()));
            }
            this.cboTelecentro.setItems(this.listaTelecentros);
            this.cboTelecentro.getSelectionModel().selectFirst();
        }
        catch (Exception e) {
            this.mensajeTelecentro("Algo ha salido mal, reinicie el aplicativo!!!");
        }
        this.btnGuardarTelecentro.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXMLConfiguracionController.this.guardarTelecentro();
                event.consume();
            }
        });
    }

    private void guardarTelecentro() {
        int idTelecentro = ((mdl_Telecentro)this.cboTelecentro.getValue()).getId();
        String nombrePuesto = this.txtNombrePuesto.getText().trim();
        String contrasena = this.txtContrasenaMaster.getText().trim();
        String contrasenaRepetir = this.txtContrasenaMasterConfirmar.getText().trim();
        if (idTelecentro == 0) {
            JOptionPane.showMessageDialog(null, "Debe seleccionar el telecentro!!!");
            return;
        }
        if (nombrePuesto.isEmpty()) {
            JOptionPane.showMessageDialog(null, "Debe indicar el nombre del puesto!!!");
            return;
        }
        if (!contrasena.equals(contrasenaRepetir)) {
            JOptionPane.showMessageDialog(null, "Las contrase\u00f1as no coinciden!!!");
            return;
        }
        try {
            CtrEncriptar enc = new CtrEncriptar();
            PrintWriter writer = new PrintWriter("telecentro.txt", "UTF-8");
            writer.println(CtrEncriptar.encriptar(idTelecentro + "|" + nombrePuesto + "|" + contrasena));
            writer.flush();
            writer.close();
            this.mensajeTelecentro("Telecentro asignado correctamente, verifique reiniciando el aplicativo.");
        }
        catch (FileNotFoundException | UnsupportedEncodingException ex) {
            this.mensajeTelecentro("No ha sido posible asignar el telecentro, conm\u00faniquese con soporte.");
        }
    }

    private void mensajeTelecentro(String mensaje) {
        this.vboxMensajeTelecentro.setVisible(true);
        this.lblMensajeTelecentro.setText(mensaje);
    }
}

